﻿namespace Emotive.Common
{
    using System;
    using System.Globalization;
    using System.Windows.Data;
    using System.Windows.Media;

    [ValueConversion(typeof(object), typeof(Brush))]
    internal class StringColorToBrushConverter
        : IMultiValueConverter
    {
        public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
        {
            var farbe = values[0] as string;
            if (farbe != null)
            {
                var color = CommonColor.SearchColorByName(farbe);
                return new SolidColorBrush(color);
            }

            return null;
        }

        public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
