﻿using System.ComponentModel;
using System.Windows;

/// <summary>
/// EMOTIVE sample classes for Device-Mapping.
/// </summary>
namespace Emotive.Services
{
    [Description("EMOTIVE sample classes to display simple dialogs.")]
    public class Dialogs
    {
        [Description("Displays a modal dialog.")]
        public ConfirmationType DisplayDialog1(string Title, string Message, MessageType Type)
        {
            MessageBoxButton messageBoxButton = MessageBoxButton.OK;
            MessageBoxImage messageBoxImage = MessageBoxImage.Information;

            switch (Type)
            {
                case MessageType.Error:
                    messageBoxImage = MessageBoxImage.Error;
                    break;
                case MessageType.YesNo:
                    messageBoxButton = MessageBoxButton.YesNo;
                    break;
                default:
                    break;
            }

            MessageBoxResult messageBoxResult = MessageBox.Show(Message, Title, messageBoxButton, messageBoxImage);

            switch (messageBoxResult)
            {
                case MessageBoxResult.Yes:
                    return ConfirmationType.Yes;
                case MessageBoxResult.No:
                    return ConfirmationType.No;
            }
            return ConfirmationType.Ok;
        }

        [Description("Displays a modal dialog.")]
        public ConfirmationType DisplayDialog2(DialogData Data)
        {
            return DisplayDialog1(Data.Title, Data.Message, Data.Type);
        }
    }
}
