﻿namespace Emotive.View
{
    using System.Windows;
    using System.Windows.Controls;
    using System.Windows.Media;

    internal class ProgressBar : UserControl
    {
        public static readonly DependencyProperty ValueProperty = DependencyProperty.Register(nameof(Value), typeof(double), typeof(ProgressBar), new FrameworkPropertyMetadata(double.NaN, FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty MinimumProperty = DependencyProperty.Register("Minimum", typeof(double), typeof(ProgressBar), new FrameworkPropertyMetadata(double.NaN, FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty MaximumProperty = DependencyProperty.Register("Maximum", typeof(double), typeof(ProgressBar), new FrameworkPropertyMetadata(double.NaN, FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty ValueValidMinimumProperty = DependencyProperty.Register(nameof(ValueValidMinimum), typeof(double), typeof(ProgressBar), new FrameworkPropertyMetadata(double.NaN, FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty ValueValidMaximumProperty = DependencyProperty.Register(nameof(ValueValidMaximum), typeof(double), typeof(ProgressBar), new FrameworkPropertyMetadata(double.NaN, FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty BarFullBrushProperty = DependencyProperty.Register(nameof(BarFullBrush), typeof(Brush), typeof(ProgressBar), new FrameworkPropertyMetadata(new SolidColorBrush(Colors.Blue), FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty BarEmptyBrushProperty = DependencyProperty.Register(nameof(BarEmptyBrush), typeof(Brush), typeof(ProgressBar), new FrameworkPropertyMetadata(new SolidColorBrush(Colors.Black), FrameworkPropertyMetadataOptions.AffectsRender));
        public static readonly DependencyProperty MarkingBrushProperty = DependencyProperty.Register(nameof(MarkingBrush), typeof(Brush), typeof(ProgressBar), new FrameworkPropertyMetadata(new SolidColorBrush(Colors.Black), FrameworkPropertyMetadataOptions.AffectsRender));

        private const double BalkenY2 = 0.65;
        private const double MarkierungY1 = 0.67;
        private const double MarkierungVerhaeltnisHoeheBreite = 0.3;

        public double Value
        {
            get
            {
                return (double)GetValue(ValueProperty);
            }

            set
            {
                SetValue(ValueProperty, value);
            }
        }

        public double Minimum
        {
            get
            {
                return (double)GetValue(MinimumProperty);
            }

            set
            {
                SetValue(MinimumProperty, value);
            }
        }

        public double Maximum
        {
            get
            {
                return (double)GetValue(MaximumProperty);
            }

            set
            {
                SetValue(MaximumProperty, value);
            }
        }

        public double ValueValidMinimum
        {
            get
            {
                return (double)GetValue(ValueValidMinimumProperty);
            }

            set
            {
                SetValue(ValueValidMinimumProperty, value);
            }
        }

        public double ValueValidMaximum
        {
            get
            {
                return (double)GetValue(ValueValidMaximumProperty);
            }

            set
            {
                SetValue(ValueValidMaximumProperty, value);
            }
        }

        public Brush BarFullBrush
        {
            get
            {
                return (Brush)GetValue(BarFullBrushProperty);
            }

            set
            {
                SetValue(BarFullBrushProperty, value);
            }
        }

        public Brush BarEmptyBrush
        {
            get
            {
                return (Brush)GetValue(BarEmptyBrushProperty);
            }

            set
            {
                SetValue(BarEmptyBrushProperty, value);
            }
        }

        public Brush MarkingBrush
        {
            get
            {
                return (Brush)GetValue(MarkingBrushProperty);
            }

            set
            {
                SetValue(MarkingBrushProperty, value);
            }
        }

        protected override void OnRender(DrawingContext drawingContext)
        {
            ZeichneBalken(drawingContext);

            if (HatGrenzwerte())
            {
                ZeichneMarkierung(drawingContext, BerechnePositionX(ValueValidMinimum));
                ZeichneMarkierung(drawingContext, BerechnePositionX(ValueValidMaximum));
            }
        }

        private void ZeichneMarkierung(DrawingContext drawingContext, double posX)
        {
            double hoehe = RenderSize.Height * MarkierungY1;
            double breite = hoehe * MarkierungVerhaeltnisHoeheBreite;

            var pathFigure = new PathFigure { IsFilled = true };
            pathFigure.Segments.Add(new LineSegment(new Point(posX, hoehe), false));
            pathFigure.Segments.Add(new LineSegment(new Point(posX + breite, RenderSize.Height), false));
            pathFigure.Segments.Add(new LineSegment(new Point(posX - breite, RenderSize.Height), false));
            pathFigure.Segments.Add(new LineSegment(new Point(posX, hoehe), false));

            var geometry = new PathGeometry();
            geometry.Figures.Add(pathFigure);

            drawingContext.DrawGeometry(MarkingBrush, new Pen(BarEmptyBrush, 1), geometry);
        }

        private void ZeichneBalken(DrawingContext drawingContext)
        {
            double hoeheBalken = RenderSize.Height;

            if (HatGrenzwerte())
            {
                hoeheBalken *= BalkenY2;
            }

            drawingContext.DrawRectangle(BarEmptyBrush, new Pen(BarEmptyBrush, 1), new Rect(0, 0, RenderSize.Width, hoeheBalken));

            double breiteLeer = BerechnePositionX(Value);

            drawingContext.DrawRectangle(BarFullBrush, new Pen(BarFullBrush, 1), new Rect(0, 0, breiteLeer, hoeheBalken));
        }

        private double BerechnePositionX(double wert)
        {
            double pos = (wert - Minimum) / (Maximum - Minimum);
            var widthLeer = RenderSize.Width * pos;
            if (widthLeer < 0)
            {
                widthLeer = 0;
            }
            else if (widthLeer > RenderSize.Width)
            {
                widthLeer = RenderSize.Width;
            }

            return widthLeer;
        }

        private bool HatGrenzwerte()
        {
            return !double.IsNaN(ValueValidMinimum) || !double.IsNaN(ValueValidMaximum);
        }
    }
}
