﻿using Emotive.ViewModel;
using System.Windows;
using System.Windows.Controls;

namespace Emotive.View
{
    /// <summary>
    /// Interaction logic for ScreenMeasurementValueControl.xaml
    /// </summary>
    public partial class ScreenMeasurementValueControl : UserControl
    {
        FrameworkElement window;
        public ScreenMeasurementValueControl()
        {
            InitializeComponent();
            
            this.Loaded += ScreenMeasurementValueControl_Loaded;
            this.Unloaded += ScreenMeasurementValueControl_Unloaded;
        }

        private void ScreenMeasurementValueControl_Loaded(object sender, RoutedEventArgs e)
        {
            window = Window.GetWindow(this);

            if (window != null)
            {
                window.PreviewKeyDown += ScreenMeasurementValueControl_PreviewKeyDown;
                window.KeyDown += ScreenMeasurementValueControl_KeyDown;
            }
            else
            {
                this.PreviewKeyDown += ScreenMeasurementValueControl_PreviewKeyDown;
                this.KeyDown += ScreenMeasurementValueControl_KeyDown;
            }
            
        }

        private void ScreenMeasurementValueControl_KeyDown(object sender, System.Windows.Input.KeyEventArgs e)
        {
            (this.DataContext as ScreenBasisViewModel).PressButtonCommand.Execute(e.Key.ToString());
        }

        private void ScreenMeasurementValueControl_PreviewKeyDown(object sender, System.Windows.Input.KeyEventArgs e)
        {
            (this.DataContext as ScreenBasisViewModel).KeyPressedCommand.Execute(e);
        }

        private void ScreenMeasurementValueControl_Unloaded(object sender, RoutedEventArgs e)
        {
            if (window != null)
            {
                window.PreviewKeyDown -= ScreenMeasurementValueControl_PreviewKeyDown;
                window.KeyDown -= ScreenMeasurementValueControl_KeyDown;
            }
        }
    }
}
