﻿using System.Collections.Generic;
using System.Collections.ObjectModel;

namespace Emotive.ViewModel
{
    public class ScreenMeasurementBarViewModel : ScreenBasisViewModel
    {
        private readonly ObservableCollection<MeasurementBarViewModel> measurementBarViewModels = new ObservableCollection<MeasurementBarViewModel>();
        public ObservableCollection<MeasurementBarViewModel> MeasurementBarViewModels
        {
            get
            {
                lock (this)
                {
                    return measurementBarViewModels;
                }
            }
        }

        private int numberOfBars;
        public int NumberOfBars
        {
            get => numberOfBars;
            set
            {
                numberOfBars = value;
                this.OnPropertyChanged(nameof(NumberOfBars));

                measurementBarViewModels.Clear();

                for (int n = 0; n < numberOfBars; ++n)
                {
                    measurementBarViewModels.Add(new MeasurementBarViewModel());
                }
            }
        }

        private List<double> barLowerLimits;
        public List<double> BarLowerLimits
        {
            get
            {
                return barLowerLimits;
            }
            set
            {
                barLowerLimits = value;
                this.OnPropertyChanged(nameof(BarLowerLimits));
                RefreshBars();
            }
        }

        private List<double> barUpperLimits;
        public List<double> BarUpperLimits
        {
            get => barUpperLimits;
            set
            {
                barUpperLimits = value;
                this.OnPropertyChanged(nameof(BarUpperLimits));
                RefreshBars();
            }
        }

        public List<double> valueValidRangeLowerLimits;
        public List<double> ValueValidRangeLowerLimits
        {
            get => valueValidRangeLowerLimits;
            set
            {
                valueValidRangeLowerLimits = value;
                this.OnPropertyChanged(nameof(ValueValidRangeLowerLimits));
                RefreshBars();
            }
        }

        private List<double> valueValidRangeUpperLimits;
        public List<double> ValueValidRangeUpperLimits
        {
            get => valueValidRangeUpperLimits;
            set
            {
                valueValidRangeUpperLimits = value;
                this.OnPropertyChanged(nameof(ValueValidRangeUpperLimits));
                RefreshBars();
            }
        }

        private List<double> values;
        public List<double> Values
        {
            get => values;
            set
            {
                this.values = value;
                this.OnPropertyChanged(nameof(Values));
                RefreshBars();
            }
        }

        private List<string> units;
        public List<string> Units
        {
            get => units;
            set
            {
                this.units = value;
                this.OnPropertyChanged(nameof(Units));
                RefreshBars();
            }
        }

        private List<string> labels;
        public List<string> Labels
        {
            get => labels;
            set
            {
                labels = value;
                this.OnPropertyChanged(nameof(Labels));
                RefreshBars();
            }
        }

        private void RefreshBars()
        {
            for (int n = 0; n < numberOfBars; ++n)
            {
                var vm = measurementBarViewModels[n];

                if (BarLowerLimits.Count >= NumberOfBars)
                {
                    vm.Minimum = BarLowerLimits[n];
                }

                if (BarUpperLimits.Count >= NumberOfBars)
                {
                    vm.Maximum = BarUpperLimits[n];
                }

                if (ValueValidRangeLowerLimits.Count >= NumberOfBars)
                {
                    vm.ValueValidMinimum = ValueValidRangeLowerLimits[n];
                }

                if (ValueValidRangeUpperLimits.Count >= NumberOfBars)
                {
                    vm.ValueValidMaximum = ValueValidRangeUpperLimits[n];
                }

                if (Values.Count >= NumberOfBars)
                {
                    vm.Value = Values[n];
                }

                if (Units.Count >= NumberOfBars)
                {
                    vm.Unit = Units[n];
                }

                if (Labels.Count >= NumberOfBars)
                {
                    vm.Label = Labels[n];
                }

                /*vm.HintergrundFarbe = HintergrundFarbe;
                vm.AuswahlHintergrundFarbe = AuswahlHintergrundFarbe;
                vm.FarbeBalkenLeer = FarbeBalkenLeer;*/
            }
        }

        public override void UpdateTheme(bool darkTheme)
        {
            base.UpdateTheme(darkTheme);
            /*foreach (var item in this.MeasurementBarViewModels)
            {
                item.UpdateTheme(darkTheme);
            }*/
        }
    }
}
