﻿using System.Windows.Forms;
using System.Collections.Generic;
using System;
using System.Threading;
using System.ComponentModel;

namespace OtxMappingSample
{
    public class Device1
    {
        #region fields
        public delegate void DeviceEventHandler(string DeviceServiceName, string DeviceServiceOutParameterName, object DeviceServiceOutParameterValue);
        public static event DeviceEventHandler DeviceEvent;

        #endregion

        #region ctors

        public Device1()
        {
        }

        #endregion

        #region methods

        public bool Service1(string message, string title)
        {
            return MessageBox.Show(message, title, MessageBoxButtons.OKCancel, MessageBoxIcon.Asterisk) == DialogResult.OK;
        }

        public void Service2(MyStructure myStructure)
        {
            string message = "StringElement1 = " + myStructure.StringElement.ToString() + "\nIntegerElement = " + myStructure.IntegerElement.ToString() + "\nByteFieldElement = " + myStructure.ByteFieldElement.ToString() + "\nListElement = " + myStructure.ListElement.ToString() + "\nMapElement = " + myStructure.MapElement.ToString();
            MessageBox.Show(message, "Structure Support", MessageBoxButtons.OK, MessageBoxIcon.Asterisk);
        }

        [Description("The simple data type DateTime can be mapped to OTX BlackBox data type")]
        public string GetTimeNow()
        {
            return DateTime.Now.ToString();
        }

        [Description("The simple data type can be mapped to OTX BlackBox data type")]
        public void DisplayString(string time)
        {
            if (time != null)
            {
                MessageBox.Show(time.ToString());
            }
            else
            {
                MessageBox.Show("Time is null");
            }
        }

        public void FireDeviceEvent(string message, string title)
        {
            RaiseDeviceEvent(message, title, null);
        }

        public Dictionary<int, Dictionary<long, double>> FetchValues(int numberOfMeasurements, int numberOfValues, int sleep = 0)
        {
            Dictionary<int, Dictionary<long, double>> values = new Dictionary<int, Dictionary<long, double>>();

            for (int i = 0; i < numberOfMeasurements; i++)
            {
                Dictionary<long, double> value = new Dictionary<long, double>();

                long timestamp = Convert.ToInt64((new TimeSpan(DateTime.Now.Ticks)).TotalMilliseconds);
                for (int j = 0; j < numberOfValues; j++)
                {
                    value.Add(timestamp + j, Math.Sin((timestamp + j) / 1000));
                }

                values.Add(i, value);
            }

            Thread.Sleep(sleep);

            return values;
        }

        private void RaiseDeviceEvent(string DeviceServiceName, string DeviceServiceOutParameterName, object DeviceServiceOutParameterValue)
        {
            if (DeviceEvent != null)
            {
                DeviceEvent(DeviceServiceName, DeviceServiceOutParameterName, DeviceServiceOutParameterValue);
            }
        }

        #endregion
    }
}
