﻿using System.Collections.Generic;

namespace OtxMappingSample
{
    public enum MainColors
    {
        None,
        Red,
        Green,
        Blue
    }

    [OtxStructure]
    public class MyStructure
    {
        private string stringElement = "Hello World";
        private int integerElement = 12;
        private byte[] byteFieldElement = new byte[] { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
        private List<int> listElement = new List<int> { 1, 2, 34 };
        private Dictionary<string, string> mapElement = new Dictionary<string, string>() { { "1", "a" }, { "2", "b" } };
        private MainColors enumElement = MainColors.Green;

        [OtxStructureElement]
        public string StringElement
        {
            get { return stringElement; }
            set { stringElement = value; }
        }

        [OtxStructureElement]
        public int IntegerElement
        {
            get { return integerElement; }
            set { integerElement = value; }
        }

        [OtxStructureElement]
        public byte[] ByteFieldElement
        {
            get { return byteFieldElement; }
            set { byteFieldElement = value; }
        }

        [OtxStructureElement]
        public List<int> ListElement
        {
            get { return listElement; }
            set { listElement = value; }
        }

        [OtxStructureElement]
        public Dictionary<string, string> MapElement
        {
            get { return mapElement; }
            set { mapElement = value; }
        }

        [OtxStructureElement]
        public MainColors EnumElement
        {
            get { return enumElement; }
            set { enumElement = value; }
        }
    }
}