﻿namespace Emotive.Common
{
    using System.Windows.Media;

    internal static class StringExtensions
    {
        public static Color ToColor(this string rgbColor)
        {
            return ToColor(rgbColor, Colors.Transparent);
        }

        public static Color ToColor(this string rgbColor, Color defaultColor)
        {
            if (!string.IsNullOrWhiteSpace(rgbColor))
            {
                return (Color)(ColorConverter.ConvertFromString('#' + rgbColor.Trim('#')) ?? defaultColor);
            }

            return defaultColor;
        }
    }
}
