﻿using Emotive.View;
using Emotive.ViewModel;
using OtxScreens.Attribute;
using System.Collections.Generic;
using System.ComponentModel;

namespace Emotive.Screens
{
    [OtxScreenSignature]
    [Description("Displays a screen with one or more horizontal measurement bars.")]
    public class ScreenMeasurementBar : ScreenBasis<ScreenMeasurementBarControl, ScreenMeasurementBarViewModel>
    {
        [OtxScreenSignatureInParameter]
        [Description("Number of measurement bars to be displayed.")]
        public int NumberOfBars
        {
            set
            {
                viewModel.NumberOfBars = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of lower limits of each measurement bar.")]
        public List<double> BarLowerLimits
        {
            set
            {
                viewModel.BarLowerLimits = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of upper limits of each measurement bar.")]
        public List<double> BarUpperLimits
        {
            set
            {
                viewModel.BarUpperLimits = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of lower limits of ranges in which the values are valid.")]
        public List<double> ValueValidRangeLowerLimits
        {
            set
            {
                viewModel.ValueValidRangeLowerLimits = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of upper limits of ranges in which the values are valid.")]
        public List<double> ValueValidRangeUpperLimits
        {
            set
            {
                viewModel.ValueValidRangeUpperLimits = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of the current values of the bars.")]
        public List<double> Values
        {
            set
            {
                viewModel.Values = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of displayed units of bars.")]
        public List<string> Units
        {
            set
            {
                viewModel.Units = value;
            }
        }

        [OtxScreenSignatureInParameter]
        [Description("List of displayed bars labels.")]
        public List<string> Labels
        {
            set
            {
                viewModel.Labels = value;
            }
        }
    }
}
