﻿using Emotive.View;
using Emotive.ViewModel;
using OtxScreens.Attribute;
using System.ComponentModel;

namespace Emotive.Screens
{
    [OtxScreenSignature]
    [Description("Displays a single measurement value")]
    public class ScreenMeasurementValue : ScreenBasis<ScreenMeasurementValueControl, ScreenMeasurementValueViewModel>
    {
        [OtxScreenSignatureInParameter]
        [Description("Description of the measurement")]
        public string Description
        {
            set { viewModel.Description = value; }
        }

        [OtxScreenSignatureInParameter]
        [Description("The value of the measurement")]
        public double Value
        {
            set { viewModel.Value = value; }
        }
    }
}
