﻿namespace Emotive.ViewModel
{
    public class ScreenMeasurementValueViewModel : ScreenBasisViewModel
    {
        private string description;
        public string Description
        {
            get { return description; }
            set
            {
                description = value;
                this.OnPropertyChanged(nameof(Description));
            }
        }

        private double value;
        public double Value
        {
            get { return value; }
            set
            {
                this.value = value;
                ValueText = $"{value:F1}";
                this.OnPropertyChanged(nameof(Value));
            }
        }

        private string valueText;
        public string ValueText
        {
            get => valueText;
            set
            {
                valueText = value;
                this.OnPropertyChanged(nameof(ValueText));
            }
        }
    }
}
