﻿using System;
using System.ComponentModel;
using System.Windows.Media;

namespace Emotive.Common
{
    internal enum OtxColor
    {
        Red, Green, Yellow, YellowAction, Blue, Gray, Black, White, Canvas, Text
    }

    internal class CommonColor : INotifyPropertyChanged
    {
        public static readonly CommonColor Instance = new CommonColor();

        public static Color LightRed => SearchColorByName(Constants.RgbLightRed);
        public static Color DarkRed => SearchColorByName(Constants.RgbDarkRed);

        public static Color LightGreen => SearchColorByName(Constants.RgbLightGreen);
        public static Color DarkGreen => SearchColorByName(Constants.RgbDarkGreen);

        public static Color LightCanvas => SearchColorByName(Constants.RgbLightCanvas);
        public static Color DarkCanvas => SearchColorByName(Constants.RgbDarkCanvas);

        public static Color LightText => SearchColorByName(Constants.RgbLightText);
        public static Color DarkText => SearchColorByName(Constants.RgbDarkText);

        public static Color DarkGray => SearchColorByName(Constants.RgbDarkGray);
        public static Color LightGray => SearchColorByName(Constants.RgbLightGray);

        public static Color Blue => SearchColorByName(Constants.RgbBlue);
        public static Color Yellow => SearchColorByName(Constants.RgbYellow);
        public static Color YellowAction => SearchColorByName(Constants.RgbGelbAction);
        public static Color Black => SearchColorByName(Constants.RgbBlack);
        public static Color White => SearchColorByName(Constants.RgbWhite);

        private bool darkTheme = false;
        public bool DarkTheme
        {
            get => darkTheme;
            set
            {
                darkTheme = value;
                this.OnPropertyChanged(nameof(DarkTheme));
            }
        }

        public Color this[OtxColor farbe]
        {
            get
            {
                switch (farbe)
                {
                    case OtxColor.Red:
                        return DarkTheme ? DarkRed : LightRed;
                    case OtxColor.Green:
                        return DarkTheme ? DarkGreen : LightGreen;
                    case OtxColor.Canvas:
                        return DarkTheme ? DarkCanvas : LightCanvas;
                    case OtxColor.Text:
                        return DarkTheme ? DarkText : LightText;
                    case OtxColor.Blue:
                        return Blue;
                    case OtxColor.Yellow:
                        return Yellow;
                    case OtxColor.YellowAction:
                        return YellowAction;
                    case OtxColor.Black:
                        return Black;
                    case OtxColor.White:
                        return White;
                    case OtxColor.Gray:
                        return DarkTheme ? DarkGray : LightGray;
                    default:
                        return White;
                }
            }
        }

        public static Color SearchColorByName(string colorName)
        {
            return SearchColorByName(colorName, Colors.White);
        }

        public static Color SearchColorByName(string colorName, Color defaultColor)
        {
            OtxColor farbe;

            if (Enum.TryParse(colorName, true, out farbe))
            {
                return Instance[farbe];
            }

            try
            {
                if (!string.IsNullOrWhiteSpace(colorName))
                {
                    return colorName.ToColor(defaultColor);
                }
            }
            catch (FormatException)
            {
            }

            return defaultColor;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public void OnPropertyChanged(string propertyName = null)
        {
            PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}
