﻿using Emotive.Common;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Emotive.ViewModel
{
    public class MeasurementBarViewModel : ViewModelBase
    {
        private string label;
        public string Label
        {
            get => label;
            set
            {
                label = value;
                this.OnPropertyChanged(nameof(Label));
            }
        }

        private double minimun;
        public double Minimum
        {
            get => minimun;
            set
            {
                minimun = value;
                this.OnPropertyChanged(nameof(Minimum));
            }
        }

        private double maximum;
        public double Maximum
        {
            get => maximum;
            set
            {
                maximum = value;
                this.OnPropertyChanged(nameof(Maximum));
            }
        }

        private double valueValidMinimum;
        public double ValueValidMinimum
        {
            get => valueValidMinimum;
            set
            {
                valueValidMinimum = value;
                this.OnPropertyChanged(nameof(ValueValidMinimum));
            }
        }

        private double valueValidMaximum;
        public double ValueValidMaximum
        {
            get => valueValidMaximum;
            set
            {
                valueValidMaximum = value;
                this.OnPropertyChanged(nameof(ValueValidMaximum));
            }
        }

        private double value;
        public double Value
        {
            get => value;
            set
            {
                this.value = value;
                ValueText = $"{value:F2}";
                this.OnPropertyChanged(nameof(Value));
                UpdateBarFullColor();
            }
        }

        private string valueText;
        public string ValueText {
            get => valueText;
            set
            {
                valueText = value;
                this.OnPropertyChanged(nameof(ValueText));
            }
        }

        private string unit;
        public string Unit
        {
            get => unit;
            set
            {
                this.unit = value;
                this.OnPropertyChanged(nameof(Unit));
            }
        }

        private string barFullColor = OtxColor.Blue.ToString();
        public string BarFullColor
        {
            get => barFullColor;
            set
            {
                this.barFullColor = value;
                this.OnPropertyChanged(nameof(BarFullColor));
            }
        }

        private string markingsColor = OtxColor.Blue.ToString();
        public string MarkingsColor
        {
            get => markingsColor;
            set
            {
                this.markingsColor = value;
                this.OnPropertyChanged(nameof(MarkingsColor));
            }
        }

        private string barEmptyColor = OtxColor.Gray.ToString();
        public string BarEmptyColor
        {
            get => barEmptyColor;
            set
            {
                this.barEmptyColor = value;
                this.OnPropertyChanged(nameof(BarEmptyColor));
            }
        }

        private void UpdateBarFullColor()
        {
            this.BarFullColor = IsValueBetweenBoundaries() ? OtxColor.Green.ToString() : OtxColor.Red.ToString();
            this.MarkingsColor = IsValueBetweenBoundaries() ? OtxColor.Green.ToString() : OtxColor.Red.ToString();
        }

        private bool IsValueBetweenBoundaries()
        {
            return (Value >= ValueValidMinimum) && (Value <= ValueValidMaximum);
        }
    }
}
